INCLUDE "config_z80_private.inc"

SECTION code_driver
SECTION code_driver_terminal_input

PUBLIC term_01_input_char_iterm_msg_getc

term_01_input_char_iterm_msg_getc:

   ;    enter : ix = & FDSTRUCT.JP
   ;
   ;     exit : a = keyboard char after character set translation
   ;            carry set on error, hl = 0 (stream error) or -1 (eof)
   ;
   ;  can use : af, bc, de, hl
   
   ; Get a character in a blocking read
   
error implement term_01_input_char_iterm_msg_getc

   ; After character is retrieved do any necessary
   ; character set translation including ascii codes
   ; 10 and 13 as shown below

   ; a = ascii code

   cp 32
   ret nc
   
   cp 10
   jr z, key_cr
   
   cp 13
   jr z, key_lf

   or a                        ; reset carry to indicate success
   ret

key_cr:

   ld a,CHAR_CR
   ret

key_lf:

   ld a,CHAR_LF
   ret
